import os
import argparse
from train import Trainer
from utils import add_train_args, init_args, check_termination

if __name__ == '__main__':

    file_os_dir = os.path.dirname(os.path.realpath(__file__))
    os.chdir(file_os_dir)

    arg_parser = argparse.ArgumentParser()
    arg_parser = add_train_args(arg_parser)

    args = arg_parser.parse_args()
    args, logger = init_args(args)

    agent = Trainer(args=args, logger=logger)
    check_termination(args,logger)
    agent.train_init()