#!/bin/sh

cd ..

mkdir -p outputs
mkdir -p log

job_name="CBI_full"

python -u main.py \
--use_wandb 0 \
--wandb_name full \
--wandb_save_model 1 \
--wandb_save_curr_model_interval 1 \
--wandb_load_model 1 \
--wandb_load_curr_model 0 \
--wandb_id to_add \
--step_to_start 0 \
--step_to_stop 2 \
--use_ce_unbiased 1 \
--label_inpainting 0 \
--label_inpainting_type new \
--lambda_distil 10. \
--distil_type pseudo_filter_style \
--distill_with_ce 0 \
--save_or_load_avg_style 1 \
--use_fda 1 \
--n_images_per_style 1000000 \
--avg_style 1 \
--L 0.01 \
--ce_curr_style 1 \
--distil_curr_style 1 \
--lambda_ce_style 10. \
--lambda_kd_style 10. \
--model erfnet \
--class_set city19 \
--incr_class_split CIL \
--incr_data_split Cityscapes-bdd100k-IDD \
--single_data_split None \
--incr_val_data all \
--data_root_path datasets \
--list_root_path datasets \
--checkpoint_dir "./log/${job_name}" \
--loss_log_step_interval 100 \
--batch_size 6 \
--resize_to 1024,512 \
--crop_to None \
--random_translation 1 \
--optim adam \
--lr 5e-4 \
--lr_incremental 5e-4 \
--weight_decay 1e-4 \
--max_iter_poly_decay 0 \
--val_interval 5 \
--val_all_data_interval 5 \
--dataset_dg_test mapillary \
--test_dg_data_interval 50 \
--wandb_img_log_interval 25 \
--epochs 100 \
--epochs_incremental 100 1> "outputs/${job_name}_$(date "+%Y-%m-%d_%H-%M-%S.txt")" 2>&1






